

% for 600 DPI
set(0, 'defaultlinelinewidth', 1.5);
set(0, 'defaulterrorbarlinewidth', 1.5);
set(0, 'defaultaxeslinewidth', 1.2);

global defaultfontsize
defaultfontsize = 14;

set(0,'defaultaxesfontsize',defaultfontsize);

plot_col_p = [0.85, 0.9, 0.9];
plot_col_m = [0.2, 0.2, 0.2];
plot_col_z = [0, 0.7, 0.8];

plot_col_PF = [0.2, 0.2, 0.2];
plot_col_UF = [0.6, 0.6, 0.6];

data = table2array(readtable('fig_2_data/spec_final.csv'));

data_flat = data;

data = reshape(data, [19, 2, 3]); % subjects, groups, metabs

data_mean = squeeze(nanmean(data));
data_std = squeeze(nanstd(data));

data_mean = reshape(data_mean, [2, 3])';
data_std = reshape(data_std, [2, 3])';

figure;
set(gcf, 'color', 'white');
subplot(2, 3, 1);

b = bar(1:3, data_mean, 0.9, 'EdgeColor', plot_col_m, 'facecolor', 'flat');
b(1).CData(1,:) = plot_col_UF;
b(1).CData(2,:) = plot_col_UF;
b(1).CData(3,:) = plot_col_UF;
b(2).CData(1,:) = plot_col_PF;
b(2).CData(2,:) = plot_col_PF;
b(2).CData(3,:) = plot_col_PF;
hold on
% Calculate the number of groups and number of bars in each group
[ngroups, nbars] = size(data_mean);
% Get the x coordinate of the bars
x = nan(nbars, ngroups);
for i = 1:nbars
    x(i, :) = b(i).XEndPoints;
end
% plot the points
plot(x(:), data_flat, 'o', 'color', plot_col_z, 'linewidth', 0.8);

plot(repmat(x(:, 1)', [19, 1])', data(:, :, 1)', '-', 'color', plot_col_z, 'linewidth', 0.8);
plot(repmat(x(:, 2)', [19, 1])', data(:, :, 2)', '-', 'color', plot_col_z, 'linewidth', 0.8);
plot(repmat(x(:, 3)', [19, 1])', data(:, :, 3)', '-', 'color', plot_col_z, 'linewidth', 0.8);

% Plot the errorbars
errorbar(x', data_mean, data_std, 'k', 'linestyle', 'none');




hold off

xlim([0.5, 3.5]);
ylim([-0.8, 1.4]);
set(gca,'YTick',-0.8:0.2:1.4);

xlabel('Metabolite');
set(gca, 'XTick', 1:3);
%set(gca, 'XTickLabel', {'Lactate (Lac)', 'Glutamate (Glu)', 'Aspartate (Asp)'});
%xtickangle(15);
set(gca, 'XTickLabel', {'Lac', 'Glu', 'Asp'});

ylabel(['Concentration Change',10,'({\mu}mol/g)']);

box off;



% df and qFDR are taken from the Sigma plot document
 
line([x(1), x(2)], [0.8, 0.8], 'color', 'k');
text(1, 0.9, '\bf\ast', 'fontsize', 16, 'horizontalalignment', 'center');
text(x(1), 1.1, 'Paired-Sample t-test', 'fontsize', 8);
text(x(1), 1.0, 'df=15, q_{FDR}=0.01', 'fontsize', 8);


line([x(3), x(4)], [0.7, 0.7], 'color', 'k');
text(2, 0.8, '\bf\ast', 'fontsize', 16, 'horizontalalignment', 'center');
text(x(3), 1.0, 'Paired-Sample t-test', 'fontsize', 8);
text(x(3), 0.9, 'df=18, q_{FDR}=0.003', 'fontsize', 8);


line([x(5), x(6)], [0.6, 0.6], 'color', 'k');
text(3, 0.66, 'n.s.', 'fontsize', 8, 'horizontalalignment', 'center');
text(x(5), 0.9, 'Paired-Sample t-test', 'fontsize', 8);
text(x(5), 0.8, 'df=18, q_{FDR}=0.98', 'fontsize', 8);

hl=legend({'UF', 'PF'}, 'location', 'northeast', 'orientation', 'horizontal');
legend boxoff
lp=get(hl,'position');
set(hl,'position',[0.4.*lp(3)+lp(1), 0.4.*lp(4)+lp(2), lp(3), lp(4)]);




%%


figure;
set(gcf, 'color', 'white');

subplot(1, 2, 1);

load('./fig_2_data/spec_data.mat');

x = ppmaxis;

y_mean_R = mean(rest0wsp);
y_std_R = std(rest0wsp);
y_R = y_mean_R./max(y_mean_R); % y=1 --> peak NAA
e_R = y_std_R./max(y_mean_R);

y_mean_PF = mean(stim7wsp);
y_std_PF = std(stim7wsp);
y_PF = -0.1+y_mean_PF./max(y_mean_PF); % y=1 --> peak NAA
e_PF = y_std_PF./max(y_mean_PF);

y_mean_UF = mean(stim30wsp);
y_std_UF = std(stim30wsp);
y_UF = -0.2+y_mean_UF./max(y_mean_UF); % y=1 --> peak NAA
e_UF = y_std_UF./max(y_mean_UF);

%plot(x, y, 'k'); 

pcol = [0, 0.7, 0.8; 0.2, 0.2, 0.2; 0.6, 0.6, 0.6];

hold on;

myshadedplot(x, y_R, e_R, pcol(1, :));
myshadedplot(x, y_PF, e_PF, pcol(2, :));
myshadedplot(x, y_UF, e_UF, pcol(3, :));



xmin = 0.2; %min(a);
xmax = 4.2; %max(a);

xlabel('Chemical Shift ({\delta}, ppm)');
set(get(gca, 'YAxis'), 'Visible','off'); 
box off;

set(gca,'XMinorTick','on');
set(get(gca, 'Xaxis'), 'MinorTickValues', xmin:0.1:xmax);

xlim([xmin, xmax]);
ylim([-0.2, 1.3]);

line([xmin, xmax], [0, 0], 'color', 'w');
h = get(gca,'Children');
set(gca,'Children',circshift(h,-1));

set(gca, 'XAxisLocation', 'bottom');

set(gca, 'XDir', 'reverse');

% ---

ctext(x, y_R, 1.32, 0.35, 'Lac', 1);
ctext(x, y_R, 2.01, 1.15, 'tNAA', 0);
ctext(x, y_R, 2.3, 0.5, 'Glu', 1);
ctext(x, y_R, 2.45, 0.4, 'Gln', 0);
ctext(x, y_R, 2.6, 0.3, 'NAA', 0);
ctext(x, y_R, 2.8, 0.22, 'Asp', 0);
ctext(x, y_R, 3.03, 0.65, 'tCr', 0);
ctext(x, y_R, 3.22, 0.38, 'Cho', 0);
ctext(x, y_R, 3.55, 0.42, 'Ins', 0);
ctext(x, y_R, 3.74, 0.55, 'Glx', 1);
ctext(x, y_R, 3.92, 0.46, 'tCr', 0);
ctext(x, y_R, 3.37, 0.3, 'Tau', 1);
ctext(x, y_R, 4.1, 0.2, 'Ins', 0);

mm_from = 0.7;
mm_to = 1.8;

mm_y = 0.4;
mm_deltay = 0.04;

line([mm_from, mm_from], [mm_y, mm_y-mm_deltay], 'linestyle', '-', 'color', 'k');
line([mm_to, mm_to], [mm_y, mm_y-mm_deltay], 'linestyle', '-', 'color', 'k');
line([mm_from, mm_to], [mm_y, mm_y], 'linestyle', '-', 'color', 'k');
line([(mm_from+mm_to)/2, (mm_from+mm_to)/2], [0.5, mm_y], 'linestyle', '-', 'color', 'k');

ctext(x, y_R, (mm_from+mm_to)/2, 0.55, 'MM', 0);

legend({'',' Rest',' PF',' UF'});
legend boxoff;


%%

figure;
set(gcf, 'color', 'white');

subplot(2, 5, 1);
data_tcr = plot_BOLD_effect('tcr'); 
%pos1 = get(gca, 'position');

subplot(2, 5, 2);
data_tnaa = plot_BOLD_effect('tnaa'); 
%pos2 = get(gca, 'position');
%set(gca, 'position', [pos2(1), pos2(2), pos1(3), pos1(4)]);

%subplot(2, 5, 3); scatter(data_tcr(:, 1), data_tcr(:, 2));
%subplot(2, 5, 8); scatter(data_tnaa(:, 1), data_tnaa(:, 2));

%{
subplot(2, 5, 3);
plot_it('ALL'); 

subplot(2, 5, 4);
plot_it('Singlets'); 
%}

%%

figure;
set(gcf, 'Color', 'w');

load('./fig_2_data/spec_diff_data.mat', 'lact', 'glut', 'cret', 'naat', ...
    'final_diff_7_rest0', 'final_diff_30_rest0', 'final_diff_7_30', 'ppmaxis');



gaussk=3; %Gaussian kernel for visualization



subplot(1, 10, 1:9);

tfsize = 20;
tx = 0.1;

col_1 = [0.2, 0.2, 0.2];
col_2 = [0, 0, 0];

col_3 = [0.8, 0.8, 0.8];

hold on;

%rectangle('position',[1.15, -2.75, 0.35, 2.5],'edgecolor',col_1,'facecolor','none');
%rectangle('position',[1.9, -2.75, 0.6, 2.5],'edgecolor',col_1,'facecolor','none');
%rectangle('position',[3.6, -2.75, 0.3, 2.5],'edgecolor',col_1,'facecolor','none');

rectangle('position',[1.15, -2.75, 0.35, 2.5],'edgecolor','none','facecolor',col_3);
rectangle('position',[1.9, -2.75, 0.6, 2.5],'edgecolor','none','facecolor',col_3);
rectangle('position',[3.6, -2.75, 0.3, 2.5],'edgecolor','none','facecolor',col_3);

rectangle('position',[1.9, 0.25, 0.2, 3.5],'edgecolor',col_1,'facecolor','none','linewidth',1.5);
rectangle('position',[2.95, 0.25, 0.15, 3.5],'edgecolor',col_1,'facecolor','none','linewidth',1.5);
rectangle('position',[3.85, 0.25, 0.15, 3.5],'edgecolor',col_1,'facecolor','none','linewidth',1.5);

%rectangle('position',[1.9, 0.25, 0.2, 3.5],'edgecolor','none','facecolor',col_3);
%rectangle('position',[2.95, 0.25, 0.15, 3.5],'edgecolor','none','facecolor',col_3);
%rectangle('position',[3.85, 0.25, 0.15, 3.5],'edgecolor','none','facecolor',col_3);

plot(ppmaxis,1.2.*lact-1.75,'color',col_2);hold on
text(tx, -1.75, 'Fitted Lac', 'fontsize',tfsize);

plot(ppmaxis,1.3.*glut-2.5,'color',col_2);
text(tx, -2.5, 'Fitted Glu', 'fontsize',tfsize);

plot(ppmaxis,1.7.*naat+0.5,'color',col_1);hold on
text(tx, +0.5, 'Fitted tNAA', 'fontsize',tfsize);

plot(ppmaxis,1.3.*cret+1.25,'color',col_1);hold on
text(tx, +1.25, 'Fitted tCr', 'fontsize',tfsize);

%{

plot(ppmaxis,aspt-2.5,'k','linewidth',1);
text(tx, -2.5, 'Asp', 'fontsize',tfsize);

%}


plot(ppmaxis,final_diff_7_rest0+3,'color',col_1); hold on
text(tx, 3, ['Difference',10,'PF-Rest'], 'fontsize',tfsize);

plot(ppmaxis,final_diff_30_rest0+2.25,'color',col_1); hold on
text(tx, 2.25, ['Difference',10,'UF-Rest'], 'fontsize',tfsize);

plot(ppmaxis,final_diff_7_30-1,'color',col_2); hold on
text(tx, -1, ['Difference',10,'PF-UF'], 'fontsize',tfsize,'fontweight','bold');


xmin = 0.2; %min(a);
xmax = 4.2; %max(a);

xlabel('Chemical Shift ({\delta}, ppm)');
set(get(gca, 'YAxis'), 'Visible','off'); 
box off;

set(gca,'XMinorTick','on');
set(get(gca, 'Xaxis'), 'MinorTickValues', xmin:0.1:xmax);

xlim([xmin, xmax]);

set(gca, 'YLim', [-3 4]);
set(gca, 'XDir', 'reverse');

pos = get(gca,'position');
set(gca,'position',[pos(1), 1.3.*pos(2), pos(3), pos(4)]);



%{
hgsave('diff_plot')


figure,set(gcf, 'Color', 'w'), plot(ppmaxis,rest0wsp)
title 'Rest, all data'
set(gca, 'XDir', 'reverse');
hgsave('rest0c')

figure,set(gcf, 'Color', 'w'), plot(ppmaxis,stim7wsp)
title 'Stim 7, all data'
set(gca, 'XDir', 'reverse');
hgsave('stim7')

figure,set(gcf, 'Color', 'w'), plot(ppmaxis,stim30wsp)
title 'Stim 30, all data'
set(gca, 'XDir', 'reverse');
hgsave('stim30')

figure,set(gcf, 'Color', 'w'), plot(ppmaxis,final_rest0_mean,'b');
hold on
plot(ppmaxis,final_7_mean,'r');
hold on
plot(ppmaxis,final_30_mean,'g');hold on
title '3 conditions, averages';
set(gca, 'XDir', 'reverse');
hgsave('averages')

figure,set(gcf, 'Color', 'w'), plot(ppmaxis,gaussfilt(1:length(final_diff_7_rest0),final_diff_7_rest0,gaussk),'b');
hold on
plot(ppmaxis,gaussfilt(1:length(final_diff_30_rest0),final_diff_30_rest0,gaussk),'r')
title 'diff 7-rest (b) and 30-rest (r) , avg'
set(gca, 'XDir', 'reverse');
hgsave('differencesstimrest0')

figure, plot(ppmaxis,gaussfilt(1:length(final_diff_7_30),final_diff_7_30,gaussk),'b')
set(gca, 'XDir', 'reverse');set(gca,'YLim',[-0.6 0.6])
title 'diff 7- 30, avg'
hgsave('difference730')
%}
figure;

load('./fig_2_data/spec_data.mat');

subplot(1, 3, 1); plot_all_spectra(ppmaxis, rest0wsp, 'REST');
subplot(1, 3, 2); plot_all_spectra(ppmaxis, stim7wsp, 'PF');
subplot(1, 3, 3); plot_all_spectra(ppmaxis, stim30wsp, 'UF');



return


%% -------------------------------------------------- Helper fns

function ctext(x, y, a, b, t, ln)

deltay1 = 0.04;
deltay2 = 0.03;

text(a, b, t, 'horizontalalignment', 'center', 'fontsize', 10);

if (ln)   
    y0 = y(x<a);
    y0 = y0(1);
    %scatter(a, y0, 'ro'); 
    
    line([a, a], [b-deltay1, y0+deltay2], 'linestyle', ':', 'color', 'k');
    
end

return
end


function data = plot_BOLD_effect(ref_signal_string)
load('./fig_2_data/spec_data.mat', 'ppmaxis');
load(sprintf('./fig_2_data/spec_bold_effect_%s.mat', ref_signal_string), 'data');

if strcmp(ref_signal_string, 'tcr')
    ppmrange = [2.82, 3.14]; % where is peak located
    ref_string = 'tCr';
elseif strcmp(ref_signal_string, 'tnaa')
    ppmrange = [1.75, 2.25]; % where is peak located     
    ref_string = 'tNAA';
elseif strcmp(ref_signal_string, 'ALL')
    ppmrange = [0.3, 4.1]; % ALL
    ref_string = 'Whole-Spectrum';
elseif strcmp(ref_signal_string, 'Singlets')
    ppmrange = [1.77, 3.13]; % Singlets
    ref_string = 'tNAA-tCr Singlets';    
else
    error('Unknown reference signal string "%s"\n', ref_signal_string);
end

% --------------------------

plot_col_p = [0.85, 0.9, 0.9];
plot_col_m = [0.2, 0.2, 0.2];
plot_col_z = [0, 0.7, 0.8];

data = 0.9424 + 0.09681.*data + 0.0157.*(data.^2); % from the FIT sigma vs FWHM

data = data.*abs(ppmaxis(1)-ppmaxis(2)).*123; % MHz, or Hz/ppm

if (1)

    hold on;
    
    %boxplot(data,'Notch','on','Labels',{'PF','UF'},'boxstyle','outline','color',[0, 0.7, 0.8],'whisker',4,'width',0.25);
    %set(findobj(gcf,'tag','Upper Whisker'), 'color',[0,0,0]);
    %set(findobj(gcf,'tag','Lower Whisker'), 'color',[0,0,0]);
    %set(findobj(gcf,'tag','Upper Adjacent Value'), 'color',[0,0,0]);
    %set(findobj(gcf,'tag','Lower Adjacent Value'), 'color',[0,0,0]);

    
    locs = zeros(size(data));
    locs(:, 1) = 1;
    locs(:, 2) = 2;

    dx = 0.2;


    bar(1:2, [mean(data(:, 1)), mean(data(:, 2))], 0.65, 'edgecolor', plot_col_m, 'facecolor', plot_col_p);

    
    scatter(locs(:), data(:), 40, 'markeredgecolor', plot_col_z);
    %errorbar(1, mean(data(:, 1)), std(data(:, 1)), 'color', 'k');
    %errorbar(2, mean(data(:, 2)), std(data(:, 2)), 'color', 'k');
    %line([1-dx, 1+dx], [mean(data(:, 1)),mean(data(:, 1))], 'color', 'k');
    %line([2-dx, 2+dx], [mean(data(:, 2)),mean(data(:, 2))], 'color', 'k');
    
    errorbar(1, mean(data(:, 1)), std(data(:, 1)), 'linestyle', 'none', 'color',  plot_col_m);
    errorbar(2, mean(data(:, 2)), std(data(:, 2)), 'linestyle', 'none', 'color',  plot_col_m);    
        
        

    
    hold off;
    
    set(gca,'xtick',1:2);
    set(gca,'xticklabel',{'PF','UF'});
end




fprintf('DeltaR2* (PF) = %.2f +/- %.2f\n', mean(data(:, 1)), std(data(:, 1)));
fprintf('DeltaR2* (UF) = %.2f +/- %.2f\n', mean(data(:, 2)), std(data(:, 2)));

[h,p,ci,stats]  = ttest(data(:, 1), data(:, 2));

%[h1, p1] = ttest(data(:, 1)-100)
%[h2, p2] = ttest(data(:, 2)-100)

xlim([0.5,2.5]);
%xlim([0,3]);
ylim([0,1]);

xlabel('Condition');
ylabel({'BOLD Effect'; '{{\Delta}R^*_2} (Hz)'});

title(ref_string, 'fontsize', 12);

box off;

text(1, 0.85, sprintf('Paired-Sample t-test'), 'color', 'k', 'fontsize', 8);
text(1, 0.8, sprintf('(df=%d, p=%.4f)', stats.df, p), 'color', 'k', 'fontsize', 10);


return
end

%%


% x, y, e(error), c(color)
% shaded area will be from y-e to y+e

function myshadedplot(x, y, e, c)

hold on;

h = area(x, [y-e; 2.*e]','HandleVisibility','off');

plot(x, y, 'Color', c);

set(h(1), 'FaceColor', 'none');
set(h, 'LineStyle', 'none');

ca = c+0.85*(1-c);
ca(ca>0.9) = 0.9;

set(h(2), 'FaceColor', ca);

set(gca, 'Layer', 'top');

return
end


function plot_all_spectra(a, b, t)

[N, ~] = size(b);

deltay = 5;
pcol = [0, 0, 0];
mcol = [0, 0.7, 0.8];

plot(a, mean(b), 'color', mcol);

hold on;
for i=1:N
    plot(a, b(i, :)+(i+3).*deltay, 'color', pcol);
end
hold off;

xmin = 0.2; %min(a);
xmax = 4.2; %max(a);

xlabel('Chemical Shift ({\delta}, ppm)');
set(get(gca, 'YAxis'), 'Visible','off'); 
box off;

set(gca,'XMinorTick','on');
set(get(gca, 'Xaxis'), 'MinorTickValues', xmin:0.1:xmax);

xlim([xmin, xmax]);
ylim([0, 45*deltay]);

set(gca, 'XDir', 'reverse');

title(sprintf('%s (N=%d)', t, N));

return
end



